package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * The Class User.
 * 
 * Description: In this User Class implements the interface Serializable and
 * defines the entity and data mapping for the dbo.User in the database.
 * 
 */
@Entity
@Table(name = "Users", schema = "dbo")
public class User implements Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 988724343861680365L;

	/** The user id. */
	@Id
	@Column(name = "User_id", unique = true, nullable = false, length = 50)
	private int userId;

	/** The first name. */
	@Column(name = "First_Name", nullable = false, length = 50)
	private String firstName;
	
	/** The middle name. */
	@Column(name = "Middle_Name", length = 50)
	private String middleName;
	
	/** The last name. */
	@Column(name = "Last_Name", nullable = false, length = 50)
	private String lastName;
	
	/** The last name 2. */
	@Column(name = "Last_Name2", length = 50)
	private String lastName2;
	
	/** The create date. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Create_Date", nullable = false, length = 23)
	private Date createDate;
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "ModifiedOn", length = 23)
	private Date modifiedOn;
	
	/** The email id. */
	@Column(name = "Email_id", nullable = false, length = 320)
	private String emailId;
	
	/** The user active. */
	@Column(name = "User_Active", nullable = false)
	private byte userActive;
	
	/** The active date. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Active_date", nullable = false, length = 23)
	private Date activeDate;
	
	/** The inactive date. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Inactive_date", length = 23)
	private Date inactiveDate;
	
	/** The user approvers for user id. */
	@OneToMany(fetch = FetchType.EAGER, mappedBy = "usersByUserId")
	private Set<UserApprover> userApproversForUserId = new HashSet<>(0);
	
	/** The user role types. */
	@OneToMany(fetch = FetchType.EAGER, mappedBy = "user")
	private Set<UserRoleType> userRoleTypes = new HashSet<>(0);
	
	/** The user approvers for user approver id. */
	@OneToMany(fetch = FetchType.EAGER, mappedBy = "usersByUserApproverId")
	private Set<UserApprover> userApproversForUserApproverId = new HashSet<>(0);

	/** The username. */
	@Column(name = "user_name", nullable = false, length = 250)
	private String username;
	
	/**
	 * Gets the user id.
	 *
	 * @return the user id
	 */
	public int getUserId() {
		return this.userId;
	}

	/**
	 * Sets the user id.
	 *
	 * @param userId the new user id
	 */
	public void setUserId(int userId) {
		this.userId = userId;
	}

	/**
	 * Gets the first name.
	 *
	 * @return the first name
	 */
	public String getFirstName() {
		return this.firstName;
	}

	/**
	 * Sets the first name.
	 *
	 * @param firstName the new first name
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * Gets the middle name.
	 *
	 * @return the middle name
	 */
	public String getMiddleName() {
		return this.middleName;
	}

	/**
	 * Sets the middle name.
	 *
	 * @param middleName the new middle name
	 */
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	/**
	 * Gets the last name.
	 *
	 * @return the last name
	 */
	public String getLastName() {
		return this.lastName;
	}

	/**
	 * Sets the last name.
	 *
	 * @param lastName the new last name
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * Gets the last name 2.
	 *
	 * @return the last name 2
	 */
	public String getLastName2() {
		return this.lastName2;
	}

	/**
	 * Sets the last name 2.
	 *
	 * @param lastName2 the new last name 2
	 */
	public void setLastName2(String lastName2) {
		this.lastName2 = lastName2;
	}

	/**
	 * Gets the creates the date.
	 *
	 * @return the creates the date
	 */
	public Date getCreateDate() {
		return this.createDate;
	}

	/**
	 * Sets the creates the date.
	 *
	 * @param createDate the new creates the date
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	
	public Date getModifiedOn() {
		return modifiedOn;
	}
	
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * Gets the email id.
	 *
	 * @return the email id
	 */
	public String getEmailId() {
		return this.emailId;
	}

	/**
	 * Sets the email id.
	 *
	 * @param emailId the new email id
	 */
	public void setEmailId(String emailId) {
		this.emailId = emailId;
	}

	/**
	 * Gets the user active.
	 *
	 * @return the user active
	 */
	public byte getUserActive() {
		return this.userActive;
	}

	/**
	 * Sets the user active.
	 *
	 * @param userActive the new user active
	 */
	public void setUserActive(byte userActive) {
		this.userActive = userActive;
	}

	/**
	 * Gets the active date.
	 *
	 * @return the active date
	 */
	public Date getActiveDate() {
		return this.activeDate;
	}

	/**
	 * Sets the active date.
	 *
	 * @param activeDate the new active date
	 */
	public void setActiveDate(Date activeDate) {
		this.activeDate = activeDate;
	}

	/**
	 * Gets the inactive date.
	 *
	 * @return the inactive date
	 */
	public Date getInactiveDate() {
		return this.inactiveDate;
	}

	/**
	 * Sets the inactive date.
	 *
	 * @param inactiveDate the new inactive date
	 */
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}

	/**
	 * Gets the user approvers for user id.
	 *
	 * @return the user approvers for user id
	 */
	public Set<UserApprover> getUserApproversForUserId() {
		return this.userApproversForUserId;
	}

	/**
	 * Sets the user approvers for user id.
	 *
	 * @param userApproversForUserId the new user approvers for user id
	 */
	public void setUserApproversForUserId(Set<UserApprover> userApproversForUserId) {
		this.userApproversForUserId = userApproversForUserId;
	}

	/**
	 * Gets the user role types.
	 *
	 * @return the user role types
	 */
	public Set<UserRoleType> getUserRoleTypes() {
		return this.userRoleTypes;
	}

	/**
	 * Sets the user role types.
	 *
	 * @param userRoleTypes the new user role types
	 */
	public void setUserRoleTypes(Set<UserRoleType> userRoleTypes) {
		this.userRoleTypes = userRoleTypes;
	}

	/**
	 * Gets the user approvers for user approver id.
	 *
	 * @return the user approvers for user approver id
	 */
	public Set<UserApprover> getUserApproversForUserApproverId() {
		return this.userApproversForUserApproverId;
	}

	/**
	 * Sets the user approvers for user approver id.
	 *
	 * @param userApproversForUserApproverId the new user approvers for user approver id
	 */
	public void setUserApproversForUserApproverId(Set<UserApprover> userApproversForUserApproverId) {
		this.userApproversForUserApproverId = userApproversForUserApproverId;
	}

	/**
	 * Gets user name
	 * 
	 * @return username the user name
	 */
	public String getUsername() {
		return username;
	}
	
	/**
	 * Sets the user name
	 * 
	 * @param username the user name
	 */
	public void setUsername(String username) {
		this.username = username;
	}
}
